// www.elegoo.com
// 2018.10.24
/*
  LED1 should be lit, showing power. LED2 indicates sound input, and the sensitivity is adjusted by potentiometer.
  There is a tiny screw on the blue potentiometer block that you can use for adjustment. Turning that
  clockwise lowers the potentiometer value, while counter-clockwise raises the potentiometer value.
  Use the potentiometer to adjust the Sound Sensor sensitivity. Turn the potentiometer
  several rotations until you see the LED2 extinguish (or just faintly blink). This might be slightly greater than
  500, if you are also watching Serial Monitor (inital adjustment), or, Serial Plotter (the latter is prefererd for observation).
  Special thanks to user CRomer, for his input and hard work!
*/

int  sensorAnalogPin = A0;    // Select the Arduino input pin to accept the Sound Sensor's analog output 
int  sensorDigitalPin = 2;    // Select the Arduino input pin to accept the Sound Sensor's digital output
int  analogValue = 0;         // Define variable to store the analog value coming from the Sound Sensor
int  digitalValue;            // Define variable to store the digital value coming from the Sound Sensor
int  Ledon = 9;                // Define LED port; this is the LED built in to the Arduino (labled L)
int  Ledoff = 11;
#include <Adafruit_GFX.h>    // include Core graphics library
#include <Adafruit_ST7735.h> // include Hardware-specific library
#define BUZZER_PIN 13
#define TFT_CS     7
#define TFT_RST    5                 
#define TFT_DC     6
#define TFT_SCLK 3 
#define TFT_MOSI 4   
Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS, TFT_DC, TFT_MOSI, TFT_SCLK, TFT_RST);                               

void setup()
{
  Serial.begin(9600);               // The IDE settings for Serial Monitor/Plotter (preferred) must match this speed
  pinMode(sensorDigitalPin,INPUT);  // Define pin 7 as an input port, to accept digital input
  pinMode(sensorAnalogPin,INPUT);
  pinMode(Ledon,OUTPUT);            // Define LED13 as an output port, to indicate digital trigger reached
  pinMode(Ledoff,OUTPUT); 
  tft.initR(INITR_BLACKTAB);
  tft.fillScreen(ST7735_BLACK);
}

void loop(){
  int keyVal = analogRead(A2);
  analogValue = analogRead(sensorAnalogPin); // Read the value of the analog interface A0 assigned to digitalValue 
  digitalValue=digitalRead(sensorDigitalPin); // Read the value of the digital interface 7 assigned to digitalValue 
  digitalWrite(Ledoff,HIGH);
  tft.setTextColor(ST7735_GREEN,ST7735_BLACK);
  tft.setTextSize(1);
  Serial.print("Analog val.: ");   
  Serial.print(analogValue); // Send the analog value to the serial transmit interface
  Serial.print("   Digital val.: ");   
  Serial.println(digitalValue); 

  tft.setTextColor(ST7735_GREEN);
  tft.setCursor(10, 10);
  tft.println("Sensor control");          //usare questa dicitura se si usa il sensore KY026, flame control
//  tft.println("Sound control");           //usare questa dicitura se si usa i sensori KY037/8,big/small sound
//  tft.println("Linear Hall control");     //usare questa dicitura se si usa il sensore KY024, linear hall
//  tft.println("Metal touch control");     //usare questa dicitura se si usa il sensore KY036, metal touch control
//  tft.println("Magnetic control");        //usare questa dicitura se si usa il sensore KY025, magnetic spring control
//  tft.println("Temperature control");     //usare questa dicitura se si usa il sensore KY028, digital temperature control  
  tft.drawLine(0,22,130,22,ST7735_GREEN);
  tft.setTextColor(ST7735_BLUE);
  tft.setCursor(10, 30);
  tft.println("Analog value  ");
  tft.setTextColor(ST7735_RED,ST7735_BLACK);
  tft.setCursor(20, 45);
  tft.println(analogValue);
  tft.drawLine(0,57,130,57,ST7735_GREEN);
  tft.setTextColor(ST7735_BLUE);
  tft.setCursor(10, 65);
  tft.println("Digital value: ");
  tft.setTextColor(ST7735_RED,ST7735_BLACK);
  tft.setCursor(20, 80);  
  tft.println(digitalValue);

      if (keyVal > 1000) {   
    digitalWrite(Ledoff,HIGH);
      digitalWrite(Ledon,LOW);  
    noTone(BUZZER_PIN);
  tft.drawLine(0,92,130,92,ST7735_GREEN);
  tft.setTextColor(ST7735_BLUE,ST7735_BLACK);
  tft.setCursor(10, 100);
  tft.println("Reset del sistema         ");
  }
  
  if(digitalValue==HIGH)     
  {
    digitalWrite(Ledon,HIGH);
    digitalWrite(Ledoff,HIGH);
    tone(BUZZER_PIN, millis()%1000+200); 
    tft.drawLine(0,92,130,92,ST7735_GREEN);
  tft.setTextColor(ST7735_RED,ST7735_BLACK);
  tft.setCursor(10, 100);
    tft.println("RILEVATA PRESENZA!       ");           //usare questa dicitura se si usa il sensore KY026, flame control
//  tft.println("RILEVATO UN SUONO!       ");   //usare questa dicitura se si usa i sensori KY037/8,big/small sound
//  tft.println("RILEV. CAMPO MAGNETICO!  ");   //usare questa dicitura se si usa il sensore KY024/5, linear hall/magnetic control
//  tft.println("CONTATTO METALLICO!      ");   //usare questa dicitura se si usa il sensore KY036, metal touch control 
  }
  else{
  tft.drawLine(0,92,130,92,ST7735_GREEN);
  tft.setTextColor(ST7735_BLUE,ST7735_BLACK);
  tft.setCursor(10, 100);
  tft.println("Nessuna presenza!           ");   //usare questa dicitura se si usa il sensore KY026, flame 
//  tft.println("Nessuna suono rilevato!   ");   //usare questa dicitura se si usa i sensori KY037/8,big/small sound 
//  tft.println("Nessun campo magnetico!   ");   //usare questa dicitura se si usa il sensore KY024/5, linear hall/magnetic control
//  tft.println("Nessun contatto metallico!");   //usare questa dicitura se si usa il sensore KY036, metal touch control


  
  //digitalWrite(Ledon,LOW);
  } 

  delay(50);                  // Slight pause so that we don't overwhelm the serial interface
}
