/*
 This circuit is for a Straight Key Code Practice Oscillator. 
   
  Straight Key (using pushbutton in place of a straight key in this Sketch)

   Sends tone to speaker connected to digital pin 8,
  when pressing the Straight   Key (pushbutton) attached to pin 2.

  The circuit:
  - Speaker - from   pin 8 through potentiometer to speaker to ground 
  - Straight Key (pushbutton)   attached to pin 2 from +5V
  - 10K resistor attached to pin 2 from ground

   created 2018
  by Jon Garber AC8XU

  This example code is in the public   domain.

 */

// constants won't change. They're used here to set pin   numbers:
const int buttonPin = A1;     // the number of the pushbutton pin
int   audio8 = 13;      // output audio on pin 13
int note = 800;      // music note/pitch
int led1 = 9;
int led2 = 11;
int treshold = 200;
//   variables will change:
int buttonState = 0;         // variable for reading the   pushbutton status

void setup() {
  // initialize the pushbutton pin as   an input:
  pinMode(buttonPin, INPUT);
  pinMode(led1, OUTPUT);
  pinMode(led2, OUTPUT);  
  Serial.begin(9600);

}

void loop() {
  //   read the state of the pushbutton value:
  buttonState = analogRead(buttonPin);

   // check if the pushbutton is pressed. If it is, the buttonState is HIGH:
   if (buttonState < treshold) {
    // turn Speaker on:
    tone(audio8, note);
    digitalWrite(led1, HIGH);
    digitalWrite(led2, LOW);
   } else {
    // turn Speaker off:
    noTone(audio8);
    digitalWrite(led1, LOW);
    digitalWrite(led2, HIGH);   
  }
  Serial.println(buttonState);
  delay(300);
}
