/*Test_DS1302_display.ino
  Creato il 15/12/2016 da Adriano Gandolfo
  Aggiornato il 7/11/2020
   This example code is in the public domain.
*/
 
#include <DS1302.h>
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2); 
const int numRows = 2;
const int numCols = 16;
//#define VCC 3 // +5V
//#define GND 4 // GND
 
// Creazione oggetto RTC
DS1302 rtc(10, 9, 7); //10 = RST; 9 = DAT; 7 = CLK


 
void setup()
{
  lcd.init();
  lcd.backlight();
//  pinMode(VCC, OUTPUT);    // imposta 'VCC' come output
//  pinMode(GND, OUTPUT);    // imposta 'GND' come output

  delay (500);
 
  // Imposta RTC in run-mode e disabilita la protezione da scrittura
  rtc.halt(false);
  rtc.writeProtect(false);
 
  // Imposta la comunicazione seriale
  Serial.begin(9600);
 
  // inizializza il display
  lcd.begin(16, 2);

 
  // Impostazione valori nella memoria del DS1302
//  rtc.setDOW(THURSDAY);        // Imposta il giorno della settimana a SUNDAY
//  rtc.setTime(21, 44, 03);     // Imposta l'ora come 11:32:00 (Formato 24hr)
//  rtc.setDate(24, 3, 2023);   // Imposta la data come 7 novembre 2020
}
 
void loop()
{
  // Invia giorno della settimana
  Serial.print(rtc.getDOWStr());
  Serial.print(" ");
 
  // Invia data
  Serial.print(rtc.getDateStr());
  Serial.print(" -- ");
 
  // Invia ora
  Serial.println(rtc.getTimeStr());
 
  // Scrive i valori sul display LCD
  lcd.clear();//cancella precedenti valori
  data (); // Scrive su LCD la data
  ora (); // Scrive su LCD l'ora
 
  // Aspetta un secondo prima di ripetere
  delay (1000);
}
 
void data ()
{
  lcd.setCursor(0, 0);
  lcd.print(rtc.getDOWStr());
  lcd.setCursor(4, 0);  
  lcd.print(". ");
  lcd.print(rtc.getDateStr());
}
 
void ora()
{
  lcd.setCursor(0, 1);
  lcd.print(rtc.getTimeStr());
}
