/******************************************
 *Website: www.elegoo.com
 * 
 *Time:2017.12.12
 *
 ******************************************/
//Define the pin connection
int CLK = 2;//CLK->D2
int DT = 3;//DT->D3
int SW = 4;//SW->D4
int led1 = 10;
int led2 = 9;
const int interrupt0 = 0;// Interrupt 0 在 pin 2 上
int count = 0;//Define the count
int countLed1;
int countLed2;
int lastCLK = 0;//CLK initial value
#define BUZZER_PIN 13
 
void setup()
{
  pinMode(SW, INPUT);
  digitalWrite(SW, HIGH);
  pinMode(CLK, INPUT);
  pinMode(DT, INPUT);
  pinMode(led1, OUTPUT);
  pinMode(led2, OUTPUT); 
  attachInterrupt(interrupt0, ClockChanged, CHANGE);//Set the interrupt 0 handler, trigger level change

  Serial.begin(9600);
}
 
void loop()
{
  if (!digitalRead(SW) && count != 0) //Read the button press and the count value to 0 when the counter reset

  {
    count = 0;
    countLed1 = 0;
    countLed2 = 0;
    analogWrite(led1,0);
    analogWrite(led2,0);
    
    Serial.print("count:");
    Serial.print(count);
    Serial.print("  countLed1: ");
    Serial.print(countLed1);
    Serial.print("  countLed2: ");
    Serial.println(countLed2);
  } 
}
 
//The interrupt handlers
void ClockChanged()
{
  int clkValue = digitalRead(CLK);//Read the CLK pin level
  int dtValue = digitalRead(DT);//Read the DT pin level
  int swValue = digitalRead(SW);//Read the sw pin level
  
  if (lastCLK != clkValue)
  {
    lastCLK = clkValue;
    count += (clkValue != dtValue ? 1 : -1);//CLK and inconsistent DT + 1, otherwise - 1

    countLed1 = count*4;
    countLed2 = count*-4;
    Serial.print("count:");
    Serial.print(count);
    Serial.print("  countLed1: ");
    Serial.print(countLed1);
    Serial.print("  countLed2: ");
    Serial.print(countLed2);
    Serial.print(" - switch state: ");
    Serial.println(swValue);



if (countLed1 < 0) {
    countLed1 = 0;
    }
if (countLed1 > 127) {
    countLed1 = 127;
    }    
    analogWrite(led1,countLed1);
  }
  if (countLed2 < 0) {
    countLed2 = 0;
    }
if (countLed2 > 127) {
    countLed2 = 127;
    }    
    analogWrite(led2,countLed2);

}
