/*     Stepper Motor using a Rotary Encoder
 *      
 *  by Dejan Nedelkovski, www.HowToMechatronics.com
 *  
 */

#include <LiquidCrystal_I2C.h>
// Imposta l'indirizzo del display a 0x27 per 16 caratteri 2 linee
LiquidCrystal_I2C lcd(0x27, 16, 2);
#include <Servo.h>
Servo myServo;

// defines pins numbers
 #define stepPin 8 
 #define dirPin  9
 #define outputA 2
 #define outputB 3

 int counter = 0;
 int angle =90; 
 int aState;
 int aLastState;  
 
void setup() {
  // Sets the two pins as Outputs
  pinMode(stepPin,OUTPUT); 
  pinMode(dirPin,OUTPUT);
  pinMode (outputA,INPUT);
  pinMode (outputB,INPUT);
  myServo.attach(5);
  
  aLastState = digitalRead(outputA);
  lcd.begin(16,2); //Init with pin default ESP8266 or ARDUINO
  lcd.backlight(); //accende la retroilluminazione

}
void loop() {

  aState = digitalRead(outputA);
   if (aState != aLastState){     
     if (digitalRead(outputB) != aState) { 
       counter ++;
       angle ++;
       myServo.write(angle);
 
     }
     else {
       counter--;
       angle --;
       myServo.write(angle);

     }
     //if (counter >=30 ) {
     // counter =0;
     if (angle > 180){
      angle = 180;
     }
      if (angle < 0){
      angle = 0;
     }
     
     lcd.clear();
     lcd.print("Position: ");
     lcd.print(int(angle));
//     lcd.print(int(angle*(-1.8)));
//     lcd.print("deg"); 
     lcd.setCursor(0,0);
     
   }
  aLastState = aState;
  
}
