#include <CD74HC4067.h>         // 16 channel analog Mux Library (CD74HC4067)
#include <Keypad.h>            // keypad Library

CD74HC4067 my_mux(2, 3, 5, 10);  // create a new CD74HC4067 object with its four control pins

const int output_pin = 13; // select a pin to share with the 16 channels of the CD74HC4067 (SIG)
const int EN_pin = 11;
int buzzer =9;


const byte ROWS = 4;  // No of Rows of Keyapd
const byte COLS = 4;  // No of Column of Keyapd

const int min_value = 48;  // int value of char '0'
const int max_value = 57;  // int value of char '9'

//define the symbols on the buttons of the keypads
char keys[ROWS][COLS] = {
  {'1', '2', '3', 'A'},
  {'4', '5', '6', 'B'},
  {'7', '8', '9', 'C'},
  {'*', '0', '#', 'D'}
};

char customKey;

byte rowPins[ROWS] = {8, 7, 4, 6}; //connect to the row pinouts of the keypad
byte colPins[COLS] = {A2, A3, A0, A1}; //connect to the column pinouts of the keypad

Keypad customKeypad = Keypad(makeKeymap(keys), rowPins, colPins, ROWS, COLS);  //Create an object of keypad

int Channel = 0;
int i;
void setup()
{
  Serial.begin(9600);
  pinMode(output_pin, OUTPUT);
  digitalWrite(output_pin, HIGH);
  pinMode(EN_pin, OUTPUT);
  digitalWrite(EN_pin, HIGH);
  pinMode(buzzer, OUTPUT);
  Serial.println("*****Enter Channel*****");
}

void loop()
{
    char customKey = customKeypad.getKey();
//    if (customKey){
//    Serial.print(customKey);
//  }
//}
  // customKey = customKeypad.getKey();   // Get Character from keypad

  if (customKey >= min_value && customKey <= max_value)
  {
    Channel = Channel * 10 + customKey - min_value;   //to store the channel value from keypad
  }

  else if (customKey == '#' && Channel <= 15)
  {
    digitalWrite(EN_pin, LOW);
    my_mux.channel(Channel);  // select channel
    String val = "Channel " + String(Channel) + " is on: " ;
    Serial.println(val);  // print values on serial monitor
    delay(300);
  }


  else if (customKey == '*')
  {
    //Serial.print("*");
    reset_program();
  }
  
else if (customKey == 'A')
  {
    for ( i = 0; i < 16; i++)
    {
      all_channel();
      tone(buzzer, 864, 70);
    }
    }
    
  else if (customKey == 'B')
  {
    for (i = 15; i >= 0; i--)
    {
      all_channel();
      tone(buzzer, 432, 70);
    }
    }
    
  else if (customKey == 'C')
  {
     for ( i = 0; i < 16; i++)
    {
      all_channel();
      tone(buzzer, 864, 70);
    }
       for (i = 15; i >= 0; i--)
    {
      all_channel();
      tone(buzzer, 432, 70);
    }
    }

 else if (customKey == 'D')
  {
     for ( i = 0; i < 8; i++)
    {
      all_channel();
      tone(buzzer, 864, 70);
    }
       for (i = 7; i >= 0; i--)
    {
      all_channel();
      tone(buzzer, 432, 70);
    }
         for ( i = 8; i < 16; i++)
    {
      all_channel();
      tone(buzzer, 1296, 70);

    }
       for (i = 15; i >= 8; i--)
    {
      all_channel();
      tone(buzzer, 648, 70);
    }
    }
   
  else if (Channel > 15)
  {
    Serial.println("Channel over 15!");
    Serial.println("Please Enter Channel 0 to 15");
    reset_program();
 }   
   } 

void reset_program()  // to stop the program
{ 
  Serial.println("reset");
  digitalWrite(EN_pin, HIGH);
  Channel = 0;
  //Serial.print("/n");
  Serial.println("*****Enter Channel*****");
}

void all_channel() {
  digitalWrite(EN_pin, LOW);
  my_mux.channel(i);
  delay(100);
  digitalWrite(EN_pin, HIGH);
} 
