#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
const int SPin[4] = {3, 4, 5, 6}; // 4 Pin usati per inviare il codice binario
const int SPin0 =3;
const int SPin1 =4;
const int SPin2 =5;
const int SPin3 =6;
int dSpin0;
int dSpin1;
int dSpin2;
int dSpin3;
int buzzer = 9;
int conta;
const int EPin = 2; /* Pin Enable
                      - se impostato HIGH interrotto fisicamente il collegamento tra il pin SIG e quello Yxx scelto
                      - se impostato LOW viene stabilito il collegamento tra il pin SIG e quello Yxx scelto */
Adafruit_SSD1306 display(128,32, &Wire, 4);

const int SIG = 7; // SIG pin

const int STable[16][4] = {
  // Crea un Array con i valori binari da richiamare in base al canale Y scelto
  // s0, s1, s2, s3, canale
  {0,  0,  0,  0}, // Y0
  {1,  0,  0,  0}, // Y1
  {0,  1,  0,  0}, // Y2
  {1,  1,  0,  0}, // Y3
  {0,  0,  1,  0}, // Y4
  {1,  0,  1,  0}, // Y5
  {0,  1,  1,  0}, // Y6
  {1,  1,  1,  0}, // Y7
  {0,  0,  0,  1}, // Y8
  {1,  0,  0,  1}, // Y9
  {0,  1,  0,  1}, // Y10
  {1,  1,  0,  1}, // Y11
  {0,  0,  1,  1}, // Y12
  {1,  0,  1,  1}, // Y13
  {0,  1,  1,  1}, // Y14
  {1,  1,  1,  1}  // Y15
};

void YSelect(int Y){
  digitalWrite(SPin0, STable[Y][0]);
  digitalWrite(SPin1, STable[Y][1]);
  digitalWrite(SPin2, STable[Y][2]);
  digitalWrite(SPin3, STable[Y][3]); 
}

void setup() {
  Serial.begin(9600);
  pinMode(buzzer, OUTPUT);
  pinMode(EPin, OUTPUT);// Inizializza EPin come OUTPUT
  digitalWrite(EPin, LOW); // presetta EPin LOW, leggere la nota all'inizio del programma per i dettagli
  
  pinMode(SIG, OUTPUT); // Inizializza SIG come OUTPUT
  digitalWrite(SIG, HIGH); // Presetta SIG HIGH, serve per il nostro esperimeto poi andrà settato a seconda delle necessità

  for (int i = 0; i < 4; i++)
  {
//    pinMode(SPin[i], OUTPUT); // Inizializza tutti gli Spin come OUTPUT
    pinMode(SPin0, OUTPUT);
    pinMode(SPin1, OUTPUT);
    pinMode(SPin2, OUTPUT);
    pinMode(SPin3, OUTPUT);
    digitalWrite(SPin0, LOW); // Setta tutti gli Spin LOW
    digitalWrite(SPin1, LOW);
    digitalWrite(SPin2, LOW);
    digitalWrite(SPin3, LOW);    

       if (!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) {
    while(true);
  }
    display.display();
    display.clearDisplay();
    display.setTextSize(2);
    display.setTextColor(WHITE);
    display.cp437(true);
  }
}

void loop() {
  for (int i = 0; i < 16; i++)
  {
        delay(300); 
    YSelect(i);
    conta = i; 
    tone(buzzer, 1000, 100); 
    visualizza();
  }
  for (int i = 15; i > 0; i--)
  {
        delay(300); 
    YSelect(i);
    conta = i;
    tone(buzzer, 1300, 100);
  
    visualizza();
  }
}

void visualizza() {
    dSpin0 = digitalRead(SPin0);
    dSpin1 = digitalRead(SPin1);
    dSpin2 = digitalRead(SPin2);
    dSpin3 = digitalRead(SPin3);
    Serial.print("Canale: ");  
    Serial.print(conta);
    Serial.print(" - binario: ");
    Serial.print(dSpin0);
    Serial.print(dSpin1);
    Serial.print(dSpin2);
    Serial.println(dSpin3); 
    display.display();
    display.clearDisplay();
    display.setTextSize(2);
    display.setTextColor(WHITE);
    display.cp437(true);  
    display.setCursor(0, 0);
    display.print("Canale ");
    display.setCursor(80, 0); 
    display.print(conta); 
    display.setCursor(0, 18);
    display.print("Bin: ");
    display.setCursor(80, 18); 
    display.print(dSpin0); display.print(dSpin1); display.print(dSpin2); display.print(dSpin3);  
}
