#include <SPI.h>
#include <MFRC522.h>
#include <Servo.h>
#include <Keypad.h>
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 16, 2);
Servo ServoMotor;

char* password = "4279";  //Qui si stabilisce la password di accesso.
// La password può avere lunghezza a piacere, dipende da come si imposta lenpsw
// se si usa la keypad 4x3, si possono usare solo numeri da 0 a 9.
// se si usa la keypad 4x4, si possono usare sia numeri che le lettere A, B, C, D
int lenpsw = 4;  //password's length
int keylen = 0;
int position = 0;
int Relay = 9;     //led + relay di controllo
int opentime = 1;  //Se opentime = 0: apertura incondizionata; se è = 1: apertura a tempo
int rfok = 0;      //flag per accedere al controllo con Rfid se 1 = ok; se 0 = erraro o in attesa
#define BUZZER_PIN 3
#define SS_PIN 10
#define RST_PIN 2
MFRC522 mfrc522(SS_PIN, RST_PIN);  // Create MFRC522 instance.


const byte ROWS = 4;  //Qui INIZIA la routine per la keypad 4x3
const byte COLS = 3;
char keys[ROWS][COLS] = {
  { '1', '2', '3' },
  { '4', '5', '6' },
  { '7', '8', '9' },
  { '*', '0', '#' }
};
byte rowPins[ROWS] = { 8, 7, 4, 6 };
byte colPins[COLS] = { A2, A3, A0 };  //Qui FINISCE la routine per la keypad 4x4

/*
const byte ROWS = 4;  //Qui INIZIA la routine per la keypad 4x3
const byte COLS = 4;

char keys[ROWS][COLS] = {
  { '1', '2', '3', 'A' },
  { '4', '5', '6', 'B' },
  { '7', '8', '9', 'C' },
  { '*', '0', '#', 'D' }
};
byte rowPins[ROWS] = { 8, 7, 4, 6 };
byte colPins[COLS] = { A2, A3, A0, A1 }; //Qui FINISCE la routine per la keypad 4x4
*/

Keypad keypad = Keypad(makeKeymap(keys), rowPins, colPins, ROWS, COLS);

void setup() {
  Serial.begin(9600);
  lcd.begin(16, 2);  //Init with pin default ESP8266 or ARDUINO
  lcd.backlight();   //accende la retroilluminazione
  lcd.setCursor(0, 0);
  lcd.print("Ins. password:");
  pinMode(Relay, OUTPUT);
  ServoMotor.attach(5);  //pin (D5) di collegamento del servomotore
  LockedPosition(true);
  pinMode(BUZZER_PIN, OUTPUT);
  SPI.begin();         // Initiate  SPI bus
  mfrc522.PCD_Init();  // Initiate MFRC522
}
void loop() {


  char key = keypad.getKey();
  if (key) {
    keylen = keylen + 1;
    Serial.print(key);
    lcd.setCursor(keylen, 1);
    lcd.print(key);
  }

  if (key == '*' || key == '#') {  //if key = "*" or key = "#", reset LockedPosition on
    position = 0;
    LockedPosition(true);
  }

  if (keylen > lenpsw) {  // if string length > password's length, reset LockedPosition on
    key = 0;
    LockedPosition(true);
  }

  if (key == password[position]) {
    position++;
  }
  if (position == lenpsw) {  // if string = password, then unlock, reset the sting's length to 0
    LockedPosition(false);
    lcd.clear();
    lcd.setCursor(0, 0);
    lcd.print("Password Ok!");
    lcd.clear();
    lcd.print("Avvicina la card");
    tone(BUZZER_PIN, 864);
    delay(250);
    noTone(BUZZER_PIN);
    keylen = 0;
    rfok = 1;
  }
  if (!mfrc522.PICC_IsNewCardPresent()) {
    return;
  }
  // Select one of the cards
  if (!mfrc522.PICC_ReadCardSerial()) {
    return;
  }


  if (rfok == 1) {
    //Show UID on serial monitor
    Serial.print("UID tag :");
    String content = "";
    byte letter;
    for (byte i = 0; i < mfrc522.uid.size; i++) {
      Serial.print(mfrc522.uid.uidByte[i] < 0x10 ? " 0" : " ");
      Serial.print(mfrc522.uid.uidByte[i], HEX);
      content.concat(String(mfrc522.uid.uidByte[i] < 0x10 ? " 0" : " "));
      content.concat(String(mfrc522.uid.uidByte[i], HEX));
    }
    //content.toUpperCase();

    if (content.substring(1) == "73 E9 FB 91" || "12 12 12 12")  //change here the UID of the card/cards that you want to give access
    {

      lcd.clear();
      lcd.setCursor(0, 0);
      lcd.print("Accesso permesso");
      digitalWrite(Relay, HIGH);
      ServoMotor.write(105);
      tone(BUZZER_PIN, 864);
      delay(250);
      noTone(BUZZER_PIN);
      delay(250);
      tone(BUZZER_PIN, 864);
      delay(250);
      noTone(BUZZER_PIN);

      switch (opentime) {

        case 0:
          lcd.setCursor(0, 1);  //INIZIA la routine per l'apertura INCONDIZIONATA della serratura
          lcd.print("* per richiudere");
          Serial.println("Authorized access. * to close again");
          lcd.setCursor(0, 1);
          lcd.print("* per richiudere");
          if (key == '*' || key == '#') {  //if key = "*" or key = "#", reset LockedPosition on
            position = 0;
            LockedPosition(true);
            digitalWrite(Relay, LOW);
            ServoMotor.write(0);
            Serial.println("Stop access");
            position = 0;
            LockedPosition(true);
            rfok = 0;
          }  //FINISCE la routine per l'apertura INCONDIZIONATA della serratura
          break;

        case 1:
          lcd.setCursor(0, 1);  // INIZIA la routine per l'apertura A TEMPO della serratura
          lcd.print("per 5 secondi");
          Serial.println("Authorized access for 5 seconds");
          delay(5000);
          digitalWrite(Relay, LOW);
          ServoMotor.write(0);
          Serial.println("Stop access");
          position = 0;
          LockedPosition(true);
          rfok = 0;  // FINISCE la routine per l'apertura A TEMPO della serratura
          break;
      }
    }
  }
  delay(100);
}

void LockedPosition(int locked) {

  if (locked) {
    digitalWrite(Relay, LOW);
    tone(BUZZER_PIN, 432);
    delay(250);
    noTone(BUZZER_PIN);
    ServoMotor.write(0);
    keylen = 0;
    lcd.clear();
    lcd.setCursor(0, 0);
    lcd.print("Ins. password:");
  }
}
